<?php

/**
 * Products, Quotations & Invoices modules.
 * Extensions to SugarCRM
 * @package Advanced OpenSales for SugarCRM
 * @subpackage Products
 * @copyright SalesAgility Ltd http://www.salesagility.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
 * along with this program; if not, see http://www.gnu.org/licenses
 * or write to the Free Software Foundation,Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301  USA
 *
 * @author Salesagility Ltd <support@salesagility.com>
 */
require_once('include/MVC/Controller/SugarController.php');
class COMM1_communicationsController extends SugarController {

    function action_listview(){
        // consultamos los templates disponibles
        $arrData = $this->getTemplatesList();
        $this->view_object_map['dataListTemplates'] = $arrData;
        $arrData = $this->getStuTiendasList();
        $this->view_object_map['dataListStuTiendas'] = $arrData;
        
        parent::action_listview();
    }
    

    private function getTemplatesList($idtpl = null){
        try{
            $res = $this->bean->db->query(
                "
                    SELECT 
                        *,
                        CONCAT(UCASE(SUBSTRING(name, 1, 1)),LCASE(SUBSTRING(name, 2))) as name
                    FROM comm1_templates_communications 
                    WHERE deleted = 0 
                ".($idtpl!=null?" AND id = '".$idtpl."' ":"")."
                    ORDER BY name ASC
                "
            );
            $mass = array();

            while ($row = $this->bean->db->fetchByAssoc($res)) {
                $mass[] = $row;
            }
            return $mass;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function getStuTiendasList($idtpl = null){
        try{
            $res = $this->bean->db->query(
                "
                    SELECT 
                        *,
                        CONCAT(UCASE(SUBSTRING(name, 1, 1)),LCASE(SUBSTRING(name, 2))) as name
                    FROM stu_tiendas 
                    WHERE deleted = 0 
                ".($idtpl!=null?" AND id = '".$idtpl."' ":"")."
                    ORDER BY name ASC
                "
            );
            $mass = array();

            while ($row = $this->bean->db->fetchByAssoc($res)) {
                $mass[] = $row;
            }
            return $mass;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    

    public function action_getHtmlTemplate(){
        try{
            // buscamos el tpl escogido
            $arrData = $this->getTemplatesList($_REQUEST['idtpl']);
            
            header("Content-type: application/json");
            // get data
            echo json_encode(array('rows'=>$arrData));
            
            return;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    public function action_salvarCampania(){
        $db = DBManagerFactory::getInstance();
        try{
            $db->query("BEGIN");
            // separamos los ids
            $arrIdCon = array();
            $this->view_object_map['strMsjResponse'] = "";
            if(isset($_REQUEST['hdnidscontacts'])){
                // verificamos q venga la fecha
                if(isset($_REQUEST['txtFechaExecute']) && $_REQUEST['txtFechaExecute']!=""){
                    $ampm = substr($_REQUEST['txtFechaExecute'],strlen($_REQUEST['txtFechaExecute'])-5);
                    if($ampm == ' p.m.'){
                        $arrhora = explode(' ',$_REQUEST['txtFechaExecute']);
                        $hora = explode(':',$arrhora[1]);
                        $hora[0] = ($hora[0]+12); 
                        // aumentamos las horas
                        $_REQUEST['txtFechaExecute'] = $arrhora[0].' '.$hora[0].':'.$hora[1];
                    }else{
                        $arrhora = explode(' ',$_REQUEST['txtFechaExecute']);
                        $hora = explode(':',$arrhora[1]);
                        if($hora[0] == 12){
                            $hora[0] = '00';
                        }
                        // aumentamos las horas
                        $_REQUEST['txtFechaExecute'] = $arrhora[0].' '.$hora[0].':'.$hora[1];
                    }

                    $arrIdCon = explode(",",$_REQUEST['hdnidscontacts']);
                    // get el html de la plantilla
                    $strHtmlTpl = $this->getTplSeleccionado();
                    // insertamos en la tabla principal de communicationsprincipal
                    $idcomm = create_guid();
                    $dateentered = @date('Y-m-d H:i:s');
                    $sql = "
                            INSERT INTO
                                comm1_communications(
                                   id,
                                   name,
                                   date_entered,
                                   created_by,
                                   description,
                                   tipo_campania,
                                   status,
                                   datetime_execute,
                                   msj_text,
                                   crossing_fields,
                                   count_msj_send,
                                   image1
                                )
                                VALUES(
                                    '".$idcomm."',
                                    '".$_REQUEST['txtNombreCampania']."',
                                    '".$dateentered."',
                                    '".$_SESSION['authenticated_user_id']."',
                                    '".$_REQUEST['tarObsCampania']."',
                                    '".$_REQUEST['selTipoCampania']."',
                                    'PENDIENTE',
                                    '".$_REQUEST['txtFechaExecute']."',
                                    '".$strHtmlTpl."',
                                       
                                    '".(isset($_REQUEST['hdnBolCamposCruzar'])&&$_REQUEST['hdnBolCamposCruzar']=='true'?'S':'N')."',
                                    '".mysqli_real_escape_string(count($arrIdCon))."',
                                    '".(isset($_FILES['img1WHATSAPP']["name"])&&$_FILES['img1WHATSAPP']["name"]!=""?$this->move_file_img_whatsapp($idcomm):"")."'
                                )
                        ";
                    $resp = $db->query($sql);
                    // recorremos los ids para insertar
                    for($i=0;$i<(int)count($arrIdCon);$i++){
                        $sql = "
                            INSERT INTO
                                comm1_clientes_communications(
                                   id,
                                   date_entered,
                                   created_by,
                                   contact_id_c,
                                   comm1_communications_id_c,
                                   status
                                )
                                VALUES(
                                    '".create_guid()."',
                                    '".$dateentered."',
                                    '".$_SESSION['authenticated_user_id']."',
                                    '".$arrIdCon[$i]."',
                                    '".$idcomm."',
                                    'PENDIENTE'
                                )
                        ";
                        $resp = $db->query($sql);
                    }
                    $this->view_object_map['strMsjResponse'] = "Proceso terminado correctamente, campa&ntilde;a creada para ejecutarse el: <b><i>".$_REQUEST['txtFechaExecute']."</i></b>";
                }else{
                    $this->view_object_map['strMsjResponse'] = "Error: Hay datos inconsistentes, la fecha de ejecuci&ntilde;n es incorrecta!";
                }
            }else{
                $this->view_object_map['strMsjResponse'] = "Error: Hay datos inconsistentes";
            }
            $this->action_listview();
            
            $db->query("COMMIT");
        } catch (Exception $ex) {
            $db->query("ROLLBACK");
            throw $ex;
        }
    }
    

    private function getTplSeleccionado(){
        try{
            // verificamos el tipo de campania
            switch($_REQUEST['selTipoCampania']){
                case "EMAIL":
                    // verificamos si es una campania guardada o abierta
                    if($_REQUEST['selTipoEMAIL'] == 'PLANTILLA'){
                        // consultamos la plantilla seleccionada
                        return $this->getTplSelectedTemplatesComm($_REQUEST['selPlantillaBdEMAIL']);
                    }else{
                        if($_REQUEST['selTipoEMAIL'] == 'ABIERTO'){
                            return $_REQUEST['tarTextoAbiertoEMAIL'];
                        }
                    }
                    break;
                case "SMS":
                    return substr($_REQUEST['tarMsjSMS'],0,160);
                case "WHATSAPP":
                    if(isset($_REQUEST['tarMsjWHATSAPP']) && $_REQUEST['tarMsjWHATSAPP']!=""){
                        return $_REQUEST['tarMsjWHATSAPP'];
                    }
                    return "";
            }
            return "";
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function getTplSelectedTemplatesComm($idtplbd){
        try{
            $arrData = $this->getTemplatesList($idtplbd);
            // verificamos los datos
            $strH = "";
            if(count($arrData)>0){
                // verificamos los 5 campos
                if(isset($arrData[0]['text1']) && $arrData[0]['text1']!="" && $arrData[0]['text1']!=null){
                    $strH .= $arrData[0]['text1'];
                }
                if(isset($arrData[0]['text2']) && $arrData[0]['text2']!="" && $arrData[0]['text2']!=null){
                    $strH .= $arrData[0]['text2'];
                }
                if(isset($arrData[0]['text3']) && $arrData[0]['text3']!="" && $arrData[0]['text3']!=null){
                    $strH .= $arrData[0]['text3'];
                }
                if(isset($arrData[0]['text4']) && $arrData[0]['text4']!="" && $arrData[0]['text4']!=null){
                    $strH .= $arrData[0]['text4'];
                }
                if(isset($arrData[0]['text5']) && $arrData[0]['text5']!="" && $arrData[0]['text5']!=null){
                    $strH .= $arrData[0]['text5'];
                }
            }
            return $strH;
        } catch (Exception $ex) {
            throw $ex;
        }
    }


    private function move_file_img_whatsapp($id){
        try{
            $ext = "";
            if(isset($_FILES["img1WHATSAPP"]["name"]) && $_FILES["img1WHATSAPP"]["name"]!=""){
                $ext = substr($_FILES["img1WHATSAPP"]["name"],strrpos($_FILES["img1WHATSAPP"]["name"],".")+1);
                copy($_FILES["img1WHATSAPP"]["tmp_name"],$_SERVER['DOCUMENT_ROOT']."/studiopruebas/tmpimagenes/img_whatsapp/".$id."_whatsapp.".$ext);
                return $id."_whatsapp.".$ext;
            }
            return $ext;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function getIdsAllContacts(){
        try{
            $res = $this->bean->db->query(
                "
                    SELECT 
                        *
                    FROM contacts
                    WHERE deleted = 0 
                "
            );
            $mass = "";

            while ($row = $this->bean->db->fetchByAssoc($res)) {
                $mass .= $row['id'].",";
            }
            return substr($mass,0,strlen($mass)-1);
        } catch (Exception $ex) {
            throw $ex;
        }
    }
}
?> 
