<?php

/**
 * Products, Quotations & Invoices modules.
 * Extensions to SugarCRM
 * @package Advanced OpenSales for SugarCRM
 * @subpackage Products
 * @copyright SalesAgility Ltd http://www.salesagility.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
 * along with this program; if not, see http://www.gnu.org/licenses
 * or write to the Free Software Foundation,Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301  USA
 *
 * @author Salesagility Ltd <support@salesagility.com>
 */
require_once('include/MVC/Controller/SugarController.php');
class stu_ventasController extends SugarController {

    function action_listview(){
        parent::action_listview();
    }
    
    /**
     * 
     * @param type $idtpl
     * @return boolean
     * @throws Exception
     */
    public function action_processArchivo($idtpl = null){
        try{
            if(isset($_FILES['filArchivo']["name"])){
                // sacamos la ext
                $ext = substr($_FILES['filArchivo']["name"],strrpos($_FILES['filArchivo']["name"],".")+1);
                if(strtolower($ext) == "xlsx"){
                    require_once("include/PHPExcel-1.8/Classes/PHPExcel/IOFactory.php");
                    $objPHPExcel = PHPExcel_IOFactory::load($_FILES['filArchivo']["tmp_name"]);
                    $objWorksheet = $objPHPExcel->getActiveSheet();

                    $highestRow = $objWorksheet->getHighestRow();
                    $highestColumn = $objWorksheet->getHighestColumn();
                    $highestColumnIndex = PHPExcel_Cell::columnIndexFromString($highestColumn);

                    $rows = array();
                    $arrDatos['rows'] = array();
                    $arrRefIn = array();
                    // organizamos los datos para poder gestionarlos de una mejor manera
                    for ($row = 1; $row <= $highestRow; ++$row) {
                        for ($col = 0; $col <= $highestColumnIndex; ++$col) {
                          $rows[$col] = $objWorksheet->getCellByColumnAndRow($col, $row)->getValue();
                        }
                        // validamos fila de titulos
                        if($row == 1){
                            // validamos el formato del archivo
                            if(!$this->validateFormatFileXlsx($rows)){
                                // set view
                                $this->action_listview();
                                return;
                            }
                            continue;
                        }
                        // validamos fila footer
                        if(strpos($rows[0]," ")){
                            continue;
                        }
                        // validamos la cantidad
                        if((int)$rows[8]<1){
                            continue;
                        }

                        if(!in_array($rows[0], $arrRefIn)){
                            $arrRefIn[] = $rows[0];
                            $arrDatos['rows'][$rows[0]] = array();
                            $date_formated = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($rows[1]));
                            $arrDatos['rows'][$rows[0]]['fecha'] = $date_formated;
                            $arrDatos['rows'][$rows[0]]['cant_prod'] = 1;
                            // set referencia
                            $arrDatos['rows'][$rows[0]]['referencias'] = array();
                            $arrDatos['rows'][$rows[0]]['referencias'][0] = array(
                                                                    'referencia'=>$rows[2],
                                                                    'desc_detalle_ext_1'=>$rows[3],
                                                                    'desc_detalle_ext_2'=>$rows[4],
                                                                    'desc_item'=>$rows[5],
                                                                    'linea'=>$rows[6],
                                                                    'coleccion'=>$rows[7],
                                                                    'cantidad'=>$rows[8],
                                                                    'valor_subtotal'=>$rows[9],
                                                                    'valor_neto'=>$rows[10],
                                                                    'valor_neto'=>$rows[10],
                                                                );
                            // set cliente
                            $arrDatos['rows'][$rows[0]]['cliente_nombre'] = $rows[11];
                            $arrDatos['rows'][$rows[0]]['cliente_identificacion'] = $rows[12];
                            $arrDatos['rows'][$rows[0]]['cliente_phonehome'] = $rows[14];
                            $arrDatos['rows'][$rows[0]]['cliente_phonemobile'] = $rows[15];
                            $arrDatos['rows'][$rows[0]]['cliente_email'] = $rows[16];
                            // set bodega
                            $arrDatos['rows'][$rows[0]]['bodega'] = $rows[13];
                            // set description
                            $arrDatos['rows'][$rows[0]]['descripcion'] = "<table>";
                            $arrDatos['rows'][$rows[0]]['descripcion'] .= "<tr>";
                            $arrDatos['rows'][$rows[0]]['descripcion'] .= "     <td>".$rows[2]."</td>";
                            $arrDatos['rows'][$rows[0]]['descripcion'] .= "     <td>".$rows[5]."</td>";
                            $arrDatos['rows'][$rows[0]]['descripcion'] .= "     <td>".$rows[3]."</td>";
                            $arrDatos['rows'][$rows[0]]['descripcion'] .= "     <td>".$rows[6]."</td>";
                            $arrDatos['rows'][$rows[0]]['descripcion'] .= "     <td>".$rows[7]."</td>";
                            $arrDatos['rows'][$rows[0]]['descripcion'] .= "</tr>";
                        }else{
                            $vrIndex = $rows[0];
                            $arrDatos['rows'][$rows[0]]['cant_prod'] ++;
                            // set referencia
                            $arrDatos['rows'][$vrIndex]['referencias'][count($arrDatos['rows'][$vrIndex]['referencias'])] = array(
                                                                    'referencia'=>$rows[2],
                                                                    'desc_detalle_ext_1'=>$rows[3],
                                                                    'desc_detalle_ext_2'=>$rows[4],
                                                                    'desc_item'=>$rows[5],
                                                                    'linea'=>$rows[6],
                                                                    'coleccion'=>$rows[7],
                                                                    'cantidad'=>$rows[8],
                                                                    'valor_subtotal'=>$rows[9],
                                                                    'valor_neto'=>$rows[10],
                                                                );
                            // set cliente
                            $arrDatos['rows'][$vrIndex]['cliente_nombre'] = $rows[11];
                            $arrDatos['rows'][$vrIndex]['cliente_identificacion'] = $rows[12];
                            $arrDatos['rows'][$vrIndex]['cliente_phonehome'] = (isset($rows[14])?$rows[14]:'');
                            $arrDatos['rows'][$vrIndex]['cliente_phonemobile'] = (isset($rows[15])?$rows[15]:'');
                            $arrDatos['rows'][$vrIndex]['cliente_email'] = (isset($rows[16])?$rows[16]:'');
                            // set bodega
                            $arrDatos['rows'][$vrIndex]['bodega'] = $rows[13];
                            // set description
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "";
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "<tr>";
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "     <td>".$rows[2]."</td>";
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "     <td>".$rows[5]."</td>";
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "     <td>".$rows[3]."</td>";
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "     <td>".$rows[6]."</td>";
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "     <td>".$rows[7]."</td>";
                            $arrDatos['rows'][$vrIndex]['descripcion'] .= "</tr>";
                        }
                        //echo '<pre>'.print_r($rows,true).'</pre>';
                    }
                    
                    // recorremosd nuevo pa cerrar el table
                    foreach ($arrDatos['rows'] as $key => $value) {
                        $arrDatos['rows'][$key]['descripcion'] .= "</table>";
                    }

                    // siguiente etapa del proceso
                    if($this->nextUploadFileInsertDatos($arrDatos)){
                        //echo '<pre>==>'.print_r($arrDatos,true).'</pre>';exit;
                        $this->view_object_map['strMsjResponse'] = "Proceso terminado correctamente, se han cargado <b>".count($arrDatos["rows"])."</b> registros";
                    }
                }else{
                    $this->view_object_map['strMsjResponse'] = "Error! Extensiones permitidas de archivo(XLSX), proceso abortado";
                }
            }else{
                $this->view_object_map['strMsjResponse'] = "Error! No se detecto el archivo(XLSX) necesario de cargue";
            }
            // set view
            $this->action_listview();
            return true;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function nextUploadFileInsertDatos($arrDatos){
        try{
            $res = $this->bean->db->query("BEGIN");

            $contR = 0;
            if(isset($arrDatos['rows'])){
                $bole = false;
                $str = "";
                foreach ($arrDatos['rows'] as $key => $value) {
                    // validamos si nose ha ingresado la factura
                    if(!$this->validateFacturaIngresadaPrevios($key)){
                        $str .= $key.', ';
                        $bole = true;
                    }
                }
                if($bole){
                    $this->view_object_map['strMsjResponse'] = ""
                                        . "Error! Se encontro inconsistencia(s) en el archivo.<br>"
                                        . "Los siguiente documentos ya han sido ingresado/cargado anteriormente<br/>"
                                        . $str
                                        . "<br/><i>Debe corregir estas inconsistencias y cargar de nuevo el archivo</i>";
                    $res = $this->bean->db->query("ROLLBACK");
                    return false;
                }
				
				$contactos = array();
				$ventasContacts = array();
				
                // recorremos el array validando q la factura no se halla ingresado antes
                foreach ($arrDatos['rows'] as $key => $value) {
                    $idventas = create_guid();
                    $dateE = @date('Y-m-d H:i:s');
                    $idtienda = $this->getIdTiendaBodega($value['bodega']);
                    // insertamos los datos de la factura
                    $res = $this->bean->db->query(
                                "
                                    INSERT INTO
                                        stu_ventas(
                                            id,
                                            name,
                                            date_entered,
                                            created_by,
                                            description,
                                            assigned_user_id,
                                            cedula_nit,
                                            fecha_documento,
                                            numero_documento,
                                            cantidad_productos,
                                            stu_tiendas_id_c
                                        )
                                        VALUES(
                                            '".$idventas."',
                                            '".$key."',
                                            now(),
                                            '".$_SESSION['authenticated_user_id']."',
                                            '".$value['descripcion']."',
                                            '".$_SESSION['authenticated_user_id']."',
                                            '".$value['cliente_identificacion']."',
                                            '".$value['fecha']."',
                                            '".$key."',
                                            '".$value['cant_prod']."',
                                            '".$idtienda."'
                                        )
                                "
                            );
					// Validar que los datos del contacto esten correctos
						array_push($contactos,[
						'identificacion'=>$value['cliente_identificacion'],
						'nombre'=>$value['cliente_nombre']
						]);
						
						array_push($ventasContacts,[
							'idventas' => $idventas,
							'$dateE' => $dateE,
							'identificacion'=>$value['cliente_identificacion'],
							'nombre'=>$value['cliente_nombre'],
							'telefono'=>$value['cliente_phonehome'],
							'movil'=> $value['cliente_phonemobile'],
							'correo'=>$value['cliente_email'],
							'idtienda'=>$idtienda,
							'referencias'=>$value['referencias']
						]);
						
                    // insertamos relacion ventas - contacts
/*					if(!$this->insertVentasContacts(
                            $idventas, $dateE, $value['cliente_identificacion'], 
                            $value['cliente_nombre'], $value['cliente_phonehome'], 
                            $value['cliente_phonemobile'], $value['cliente_email'],
                            $idtienda
                    )){
                        $res = $this->bean->db->query("ROLLBACK");
						//exit(print_r($res));
                        return false;
                    }
                    
                    // recorremos el detalle e intertamos
                    if(isset($value['referencias'])){
                        foreach($value['referencias'] as $key_2 => $value_2){
                            // insertamos el detalle
                            if(!$this->insertDetalleFactura($idventas, $dateE, $value_2)){
                                $res = $this->bean->db->query("ROLLBACK");
                                return false;
                            }
                        }
                    }*/
					
                } // fin foreach principal
            }
			// Validar que los datos del contacto esten correctos
			$rvcc=$this->realVerifyContactCreated($contactos);
			if($rvcc === true){
				// insertamos relacion ventas - contacts
				foreach($ventasContacts as $vc){
					$ivc = $this->insertVentasContacts(
						$vc['idventas'], $vc['dateE'], $vc['identificacion'], 
						$vc['nombre'], $vc['telefono'], 
						$vc['movil'], $vc['correo'],
						$vc['idtienda']
                    );
					if(!$ivc){
						$res = $this->bean->db->query("ROLLBACK");
                        return false;
					}
					
					if(isset($vc['referencias'])){
                        foreach($vc['referencias'] as $key_2 => $value_2){
                            // insertamos el detalle
							$idf = $this->insertDetalleFactura($vc['idventas'], $vc['dateE'], $value_2);
                            if(!idf){
                                $res = $this->bean->db->query("ROLLBACK");
                                return false;
                            }
                        }
                    }
				}
			}else{
				$res = $this->bean->db->query("ROLLBACK");
//				echo '<pre>';
//				print_r($rvcc);
				$this->view_object_map['strMsjResponse'] = $rvcc;
				return false;
			}

            $res = $this->bean->db->query("COMMIT");
            
            return true;
        } catch (Exception $ex) {
            $res = $this->bean->db->query("ROLLBACK");
            throw $ex;
        }
    }
    

    private function insertVentasContacts($idventas,$dateE, $identi, $nombres,$phonecasa,$phonemobile,$email,$idtienda){
        try{
            // verificamos si el contacto existe en bd sino lo creamos
            $idCli = $this->verifyContactCreated($identi, $nombres,$dateE,$phonecasa,$phonemobile,$email,$idtienda);
            if($idCli == -1){
                return false;
            }
            
            // insertamos la relacion contact - ventas
            $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                stu_ventas_contacts_c(
                                    id,
                                    date_modified,
                                    stu_ventas_contactscontacts_ida,
                                    stu_ventas_contactsstu_ventas_idb
                                )
                                VALUES(
                                    '".create_guid()."',
                                    '".$dateE."',
                                    '".$idCli."',
                                    '".$idventas."'
                                )
                        "
                    );
            return true;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function verifyContactCreated($identi, $nombres, $dateE,$phonecasa,$phonemobile,$email,$idtienda){
        try{
           /* $res = $this->bean->db->query(
                        "
                            SELECT
                                conta.*
                            FROM
                                contacts conta
                                    INNER JOIN
                                        contacts_cstm cstm ON
                                            conta.id = cstm.id_c
                            WHERE
                                TRIM(cstm.cedula_nit_c) = '".trim($identi)."' AND
                                conta.deleted = 0    
                        "
                    );
            if(isset($res->num_rows) && $res->num_rows>1){
                // error
                $this->view_object_map['strMsjResponse'] = "Error! Existe inconsistencias con el CONTACTO <b>".$nombres."</b>, ya que se encontraron <b>".$res->num_rows."</b> registros en el CRM con el mismo numero de identificaci&oacute;n: <b>".$identi.", debe corregir esto y volver a cargar el archivo</b>";
                return -1;
            }elseif(!isset($res->num_rows)  || $res->num_rows == 0){*/
                // creamos el contacto nuevo
                $idCli = $this->createdNewContact($identi, $nombres, $dateE,$phonecasa,$phonemobile,$email);
                if($idCli != false){
                    // creamos la relacion cotnact - tienda
                    $result = $this->insertTiendaContacto($idCli,$idtienda,$dateE);
                    if($result == false){
                        return -1;
                    }else{
                        return $idCli;
                    }
                }else{
                    return -1;
                }
//            }
            // retornamos el id del contact q ya existe
/*            while ($row = $this->bean->db->fetchByAssoc($res)) {
                // veriricamos si el nit pertenece al nombre
                $strNC = strtolower($row['first_name'].($row['last_name']!=null?" ".$row['last_name']:""));
                if($strNC != strtolower($nombres)){
                    $this->view_object_map['strMsjResponse'] = "Error! El contacto con la identificaci&oacute;n: <b>".$identi."</b>, tiene datos inconsistentes ya que en el CRM aparece con otro nombre, verifique, solucione y vuelva a cargar el archivo";
                    return -1;
                }
                return $row['id'];
            }*/
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    /**
     * ingresa la relacion cotnact - tienda cuando s inserta por priera vez
     * 
     * @param type $idcliente
     * @param type $idtienda
     * @param type $dateE
     * @throws Exception
     */
    private function insertTiendaContacto($idcliente,$idtienda,$dateE){
        try{
            $res = $this->bean->db->query(
                "
                    INSERT INTO
                        stu_tiendas_contacts_c(
                            id,
                            date_modified,
                            stu_tiendas_contactsstu_tiendas_ida,
                            stu_tiendas_contactscontacts_idb
                        )
                        VALUES(
                            '".create_guid()."',
                            now(),
                            '".$idtienda."',
                            '".$idcliente."'
                        )
                "
            );
            return true;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function createdNewContact($identi, $nombres, $dateE,$phonecasa,$phonemobile,$email){
        try{
            // validamos pos email, celular, y por nombre antes d crear el new
            $idc_aux = $this->validar_datos_extras_contact($email,$phonemobile,$nombres);
            if($idc_aux != -1){
                return $idc_aux;
            }
            $idcliente = create_guid();
            // insert contacts
            $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                contacts(
                                    id,
                                    date_entered,
                                    created_by,
                                    first_name,
                                    phone_home,
                                    phone_mobile
                                )
                                VALUES(
                                    '".$idcliente."',
                                    now(), 
                                    '".$_SESSION['authenticated_user_id']."',
                                    '".$nombres."',
                                    '".$phonecasa."',
                                    '".$phonemobile."'
                                )
                        "
                    );
            // insert contacts cstm
            $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                contacts_cstm(
                                    id_c,
                                    cedula_nit_c,
                                    sexo_c,
                                    mes_cumpleanos_c
                                )
                                VALUES(
                                    '".$idcliente."',
                                    '".$identi."',
                                    '',
                                    ''
                                )
                        "
                    );
            // verificamos si eesta el email
            if($email!=""){
                // creamos la relacion cliente email
                $idemailadresses = create_guid();
                $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                email_addresses(
                                    id,
                                    email_address,
                                    email_address_caps,
                                    date_created
                                )
                                VALUES(
                                    '".$idemailadresses."',
                                    '".$email."',
                                    '".strtoupper($email)."',
                                    '".$dateE."'
                                )
                        "
                    );
                $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                email_addr_bean_rel(
                                    id,
                                    email_address_id,
                                    bean_id,
                                    bean_module,
                                    primary_address,
                                    date_created
                                )
                                VALUES(
                                    '".create_guid()."',
                                    '".$idemailadresses."',
                                    '".$idcliente."',
                                    'Contacts',
                                    1,
                                    '".$dateE."'
                                )
                        "
                    );
            }
            return $idcliente;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    private function validar_datos_extras_contact($email,$phonemobile,$nombres){
        try{
            // buscamos si existe el email
            $res = $this->bean->db->query(
                "
                    SELECT
                        rel.*
                    FROM
                        email_addresses email
                            INNER JOIN
                                email_addr_bean_rel rel ON
                                    email.id = rel.email_address_id
                    WHERE
                        TRIM(email.email_address) = '".trim($email)."' AND
                        email.deleted = 0 AND
                        rel.deleted = 0
                "
            );
            if(trim($email) != "" && isset($res->num_rows) && $res->num_rows>0){
                // contacto encontrado por email
                while ($row = $this->bean->db->fetchByAssoc($res)) {
                    return $row['bean_id'];
                }
            }else{
                // buscamos por el num de celular
                $res = $this->bean->db->query(
                    "
                        SELECT
                            cont.*
                        FROM
                            contacts cont
                        WHERE
                            TRIM(cont.phone_mobile) = '".trim($phonemobile)."' AND
                            cont.deleted = 0
                    "
                );
                if(trim($phonemobile)!="" && isset($res->num_rows) && $res->num_rows>0){
                    // contacto encontrado por celular
                    while ($row = $this->bean->db->fetchByAssoc($res)) {
                        return $row['id'];
                    }
                }else{
                    // buscamos por el nombre del cliente
                    $res = $this->bean->db->query(
                        "
                            SELECT
                                cont.*
                            FROM
                                contacts cont
                            WHERE
                                TRIM(LOWER(cont.first_name)) = '".trim(strtolower($nombres))."' AND
                                cont.deleted = 0
                        "
                    );
                    if(isset($res->num_rows) && $res->num_rows>0){
                        // contacto encontrado por nombre
                        while ($row = $this->bean->db->fetchByAssoc($res)) {
                            return $row['id'];
                        }
                    }
                }
            }
            
            return -1;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function insertDetalleFactura($idventas,$dateE,$arrDatosDetalle){
        try{
            // verificamos y retorn id y nombre producto
            $arrDDet = $this->getDatosProductoAos($arrDatosDetalle,$dateE);
            if($arrDDet == -1){
                return false;
            }
            $idDetalle = create_guid();
            $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                stu_ventas_detalle(
                                    id,
                                    name,
                                    date_entered,
                                    created_by,
                                    cantidad,
                                    valor_neto,
                                    aos_products_id_c,
                                    stu_tallas_id_c,
                                    stu_colores_id_c,
                                    stu_linea_id_c,
                                    stu_colecciones_id_c
                                )
                                VALUES(
                                    '".$idDetalle."',
                                    '".$arrDDet['name_producto']."',
                                    now(),
                                    '".$_SESSION['authenticated_user_id']."',
                                    '".$arrDatosDetalle['cantidad']."',
                                    '".$arrDatosDetalle['valor_neto']."',
                                    '".$arrDDet['id_producto']."',
                                    '".$arrDDet['id_talla']."',
                                    '".$arrDDet['id_color']."',
                                    '".$arrDDet['id_linea']."',
                                    '".$arrDDet['id_coleccion']."'
                                )
                        "
                    );
            // creamos la relacion stu_ventas_ - stu_ventas_detalle
            if(!$this->setRelVentasDetalles($idventas,$idDetalle,$dateE)){
                return false;
            }
            return true;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function setRelVentasDetalles($idventas,$idDetalle,$dateE){
        try{
            $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                stu_ventas_stu_ventas_detalle_c(
                                    id,
                                    date_modified,
                                    stu_ventas_stu_ventas_detallestu_ventas_ida,
                                    stu_ventas_stu_ventas_detallestu_ventas_detalle_idb
                                )
                                VALUES(
                                    '".create_guid()."',
                                    '".$dateE."',
                                    '".$idventas."',
                                    '".$idDetalle."'
                                )
                        "
                    );
            return true;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function getDatosProductoAos($arrDatosDetalle,$dateE){
        try{
            // verificamos y creamos el color
            $idcolor = $this->verificaCreaColor($arrDatosDetalle['desc_detalle_ext_1'],$dateE);
            if($idcolor == false){
                return -1;
            }
            // verificamos y creamos la talla
            $idtalla = $this->verificaCreaTalla($arrDatosDetalle['desc_detalle_ext_2'],$dateE);
            if($idtalla == false){
                return -1;
            }
            // verificamos y creamos la linea
            $idlinea = $this->verificaCreaLinea($arrDatosDetalle['linea'],$dateE);
            if($idlinea == false){
                return -1;
            }
            // verificamos y creamos la coleccion
            $idColec = $this->verificaCreaColeccion($arrDatosDetalle['coleccion'],$dateE);
            if($idColec == false){
                return -1;
            }
            // verificamos si existe el producto con la referencia
            $res = $this->bean->db->query(
                        "
                            SELECT
                                prod.*,
                                cstm.desc_item_c
                            FROM
                                aos_products prod
                                    INNER JOIN
                                        aos_products_cstm cstm ON
                                            prod.id = cstm.id_c
                            WHERE
                                TRIM(name) = '".trim($arrDatosDetalle['referencia'])."' AND
                                prod.deleted = 0
                        "
                    );
            if(isset($res->num_rows) && $res->num_rows>1){
                $this->view_object_map['strMsjResponse'] = "Error! Existe inconsistencias con la REFERENCIA <b>".$arrDatosDetalle['referencia']."</b>, ya que se encontraron (".$res->num_rows.") registros en el CRM con la misma referencia, debe corregir esto y volver a cargar el ARCHIVO";
                return -1;
            }elseif(!isset($res->num_rows)  || $res->num_rows == 0){
                // creamos el registro nuevo
                $arrDatoProdN = $this->createdProductoNuevo($arrDatosDetalle,$idcolor,$idtalla,$idlinea,$idColec,$dateE);
                $arrDatoProdN['id_talla'] = $idtalla;
                $arrDatoProdN['id_color'] = $idcolor;
                $arrDatoProdN['id_linea'] = $idlinea;
                $arrDatoProdN['id_coleccion'] = $idColec;
                if($arrDatoProdN == false){
                    return -1;
                }
                return $arrDatoProdN;
            }
            // si ya existe el producto
            while ($row = $this->bean->db->fetchByAssoc($res)) {
                return array(
                            'id_producto'=>$row['id'],'name_producto'=>$row['name'],
                            'id_talla'=>$idtalla,
                            'id_linea'=>$idlinea,
                            'id_color'=>$idcolor,
                            'id_coleccion'=>$idColec
                        );
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function createdProductoNuevo($arrDatosDetalle,$idcolor,$idtalla,$idlinea,$idColec,$dateE){
        try{
            // creamos el producto
            $idprod = create_guid();
            $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                aos_products(
                                    id,
                                    name,
                                    cost,
                                    price,
                                    created_by,
                                    date_entered
                                )
                                VALUES(
                                    '".$idprod."',
                                    '".$arrDatosDetalle['referencia']."',
                                    '".$arrDatosDetalle['valor_subtotal']."',
                                    '".$arrDatosDetalle['valor_neto']."',
                                    '".$_SESSION['authenticated_user_id']."',
                                   now()
                                )
                        "
                    );
            // creamos en custom table
            $res = $this->bean->db->query(
                        "
                            INSERT INTO
                                aos_products_cstm(
                                    id_c,
                                    stu_colores_id_c,
                                    stu_linea_id_c,
                                    stu_colecciones_id_c,
                                    desc_item_c
                                )
                                VALUES(
                                    '".$idprod."',
                                    '".$idcolor."',
                                    '".$idlinea."',
                                    '".$idColec."',
                                    '".$arrDatosDetalle['desc_item']."'
                                )
                        "
                    );
            return array('id_producto'=>$idprod,'name_producto'=>$arrDatosDetalle['desc_item']);
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function verificaCreaColor($colorN,$dateE){
        try{
            // consultamos el id del color o lo creamos
            $res = $this->bean->db->query(
                        "
                            SELECT
                                *
                            FROM
                                stu_colores
                            WHERE
                                TRIM(name) = '".trim($colorN)."' AND
                                deleted = 0
                        "
                    );
            if(isset($res->num_rows) && $res->num_rows>1){
                $this->view_object_map['strMsjResponse'] = "Error! Existe inconsistencias con el color <b>".$colorN."</b>, esta creado (".$res->num_rows.") veces en la base de datos del CRM, corregir esto y volver a cargar el archivo";
                return false;
            }elseif(!isset($res->num_rows) || $res->num_rows == 0){
                // creamos el color nuevo
                $idcolor = create_guid();
                $res = $this->bean->db->query(
                            "
                                INSERT INTO
                                    stu_colores(
                                        id,
                                        name,
                                        created_by,
                                        date_entered
                                    )
                                    VALUES(
                                        '".$idcolor."',
                                        '".strtoupper($colorN)."',
                                        '".$_SESSION['authenticated_user_id']."',
                                        now()
                                    )
                            "
                        );
                // insert en cstm
                $res = $this->bean->db->query(
                            "
                                INSERT INTO
                                    stu_colores_cstm(
                                        id_c
                                    )
                                    VALUES(
                                        '".$idcolor."'
                                    )
                            "
                        );
                return $idcolor;
            } // fin ifelse
            while ($row = $this->bean->db->fetchByAssoc($res)) {
                return $row['id'];
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function verificaCreaTalla($tallaN,$dateE){
        try{
            // consultamos el id del color o lo creamos
            $res = $this->bean->db->query(
                        "
                            SELECT
                                *
                            FROM
                                stu_tallas
                            WHERE
                                TRIM(name) = '".trim($tallaN)."' AND
                                deleted = 0
                        "
                    );
            if(isset($res->num_rows) && $res->num_rows>1){
                $this->view_object_map['strMsjResponse'] = "Error! Existe inconsistencias con la talla <b>".$tallaN."</b>, esta creado (".$res->num_rows.") veces en la base de datos del CRM, corregir esto y volver a cargar el archivo";
                return false;
            }elseif(!isset($res->num_rows) || $res->num_rows == 0){
                // creamos el color nuevo
                $id = create_guid();
                $res = $this->bean->db->query(
                            "
                                INSERT INTO
                                    stu_tallas(
                                        id,
                                        name,
                                        created_by,
                                        date_entered
                                    )
                                    VALUES(
                                        '".$id."',
                                        '".strtoupper($tallaN)."',
                                        '".$_SESSION['authenticated_user_id']."',
                                        now()
                                    )
                            "
                        );
                return $id;
            } // fin ifelse
            while ($row = $this->bean->db->fetchByAssoc($res)) {
                return $row['id'];
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function verificaCreaLinea($strN,$dateE){
        try{
            $arrLin = explode(" - ",$strN);
            // consultamos el id del linea o lo creamos
            $res = $this->bean->db->query(
                        "
                            SELECT
                                *
                            FROM
                                stu_linea
                            WHERE
                                TRIM(name) = '".trim($arrLin[0])."' AND
                                TRIM(description) = '".trim($arrLin[1])."' AND
                                deleted = 0
                        "
                    );
            if(isset($res->num_rows) && $res->num_rows>1){
                $this->view_object_map['strMsjResponse'] = "Error! Existe inconsistencias con la linea <b>".$strN."</b>, esta creado (".$res->num_rows.") veces en la base de datos del CRM, corregir esto y volver a cargar el archivo";
                return false;
            }elseif(!isset($res->num_rows) || $res->num_rows == 0){
                // creamos la linea nuevo
                $id = create_guid();
                $res = $this->bean->db->query(
                            "
                                INSERT INTO
                                    stu_linea(
                                        id,
                                        name,
                                        description,
                                        created_by,
                                        date_entered
                                    )
                                    VALUES(
                                        '".$id."',
                                        '".strtoupper($arrLin[0])."',
                                        '".strtoupper($arrLin[1])."',
                                        '".$_SESSION['authenticated_user_id']."',
                                        now()
                                    )
                            "
                        );
                return $id;
            } // fin ifelse
            while ($row = $this->bean->db->fetchByAssoc($res)) {
                return $row['id'];
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function verificaCreaColeccion($strN,$dateE){
        try{
            $arrLin = explode(" - ",$strN);
            // consultamos el id del linea o lo creamos
            $res = $this->bean->db->query(
                        "
                            SELECT
                                *
                            FROM
                                stu_colecciones
                            WHERE
                                TRIM(name) = '".trim($arrLin[0])."' AND
                                TRIM(description) = '".trim($arrLin[1])."' AND
                                deleted = 0
                        "
                    );
            if(isset($res->num_rows) && $res->num_rows>1){
                $this->view_object_map['strMsjResponse'] = "Error! Existe inconsistencias con la coleccion <b>".$strN."</b>, esta creado (".$res->num_rows.") veces en la base de datos del CRM, corregir esto y volver a cargar el archivo";
                return false;
            }elseif(!isset($res->num_rows) || $res->num_rows == 0){
                // creamos la linea nuevo
                $id = create_guid();
                $res = $this->bean->db->query(
                            "
                                INSERT INTO
                                    stu_colecciones(
                                        id,
                                        name,
                                        description,
                                        created_by,
                                        date_entered
                                    )
                                    VALUES(
                                        '".$id."',
                                        '".strtoupper($arrLin[0])."',
                                        '".strtoupper($arrLin[1])."',
                                        '".$_SESSION['authenticated_user_id']."',
                                        now()
                                    )
                            "
                        );
                return $id;
            } // fin ifelse
            while ($row = $this->bean->db->fetchByAssoc($res)) {
                return $row['id'];
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function getIdTiendaBodega($strTienda){
        try{
            //$strTienda = substr($strTienda,0,strpos($strTienda, " "));
            $res = $this->bean->db->query(
                        "
                            SELECT
                                id
                            FROM
                                stu_tiendas
                            WHERE
                                LOWER(name) = '".strtolower($strTienda)."' AND
                                deleted = 0
                        "
                    );
            while ($row = $this->bean->db->fetchByAssoc($res)) {
                return $row["id"];
            }
            return false;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function validateFacturaIngresadaPrevios($nfactura){
        try{
            $res = $this->bean->db->query(
                        "
                            SELECT
                                COUNT(*) as cont_f
                            FROM
                                stu_ventas
                            WHERE
                                numero_documento = '".$nfactura."' AND
                                deleted = 0
                       "
                    );
            while ($row = $this->bean->db->fetchByAssoc($res)) {
                $cont = $row["cont_f"];
            }
            
            // validamos
            if((int)$cont > 0){
                return false;
            }else{
                return true;
            }
            
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    

    private function validateFormatFileXlsx($rows){
        try{
            if(count($rows)<13){
                $this->view_object_map['strMsjResponse'] = "El archivo no tiene la estructura correcta, <b>deben ser minimo 17 COLUMNAS con informaci&oacute;n valida</b>";
                return false;
            }
            return true;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
	

    private function realVerifyContactCreated($contactos){
        try{
			$mensaje = ""; 
			foreach($contactos as $contacto){
				        $res = $this->bean->db->query(
                        "
                            SELECT
                                conta.*
                            FROM
                                contacts conta
                                    INNER JOIN
                                        contacts_cstm cstm ON
                                            conta.id = cstm.id_c
                            WHERE
                                TRIM(cstm.cedula_nit_c) = '".trim($contacto['identificacion'])."' AND
                                conta.deleted = 0    
                        "
                    );
				if(isset($res->num_rows) && $res->num_rows>1){
					// error
					$mensaje .= "Error! Existe inconsistencias con el CONTACTO <b>".$contacto['nombre']."</b>, ya que se encontraron <b>".$res->num_rows."</b> registros en el CRM con el mismo numero de identificaci&oacute;n: <b>".$contacto['identificacion'].", debe corregir esto y volver a cargar el archivo</b><br>";
				}
				// retornamos el id del contact q ya existe
				while ($row = $this->bean->db->fetchByAssoc($res)) {
					// veriricamos si el nit pertenece al nombre
					$strNC = strtolower($row['first_name'].($row['last_name']!=null?" ".$row['last_name']:""));
					if($strNC != strtolower($contacto['nombre'])){
						$mensaje .= "Error! El contacto con la identificaci&oacute;n: <b>".$contacto['identificacion']."</b>, tiene datos inconsistentes ya que en el CRM aparece con otro nombre, verifique, solucione y vuelva a cargar el archivo<br>";
					}
				}
			}
			if($mensaje != "")
				return $mensaje;
			else
				return true;

        } catch (Exception $ex) {
            throw $ex;
        }
    }
}
?> 
