<?php  

require_once '../include/configuracion/grid/jq-config.php';
// include the jqGrid Class 
require_once ABSPATH."php/jqGrid.php"; 
// include the driver class 
require_once ABSPATH."php/jqGridPdo.php"; 
// Connection to the server 
$conn = new PDO(DB_DSN,DB_USER,DB_PASSWORD); 
// Tell the db that we use utf-8 
$conn->query("SET NAMES utf8"); 
// Create the jqGrid instance 
$grid = new jqGridRender($conn); 
// Write the SQL Query
	$grid->SelectCommand = "
						SELECT	
							s.id as id_acc,
							p.pedido,
							DATE_FORMAT(p.date_entered,'%Y-%m-%d')as date_entered,
							CONCAT(s.nombre) as cliente,
							p.account_id,
							concat(u.first_name,' ',u.last_name) as vendedor,
							p.id,
							(
								SELECT
									descripcion
								FROM
									generales
								WHERE
									id = p.estado AND
									tipo = 'ESTADO_PEDIDO'
							) as estado,
							p.estado as estado_id,
							'' as ver,
							'' as anular																									
						FROM
							sucursales s,
							pedidos p,
							users u						
						WHERE
							p.account_id =  s.id AND
							u.id = p.created_by AND
							(p.estado in(1))";
	//Filtro Vendedor
	if(isset($_GET['vendedor']) && $_GET['vendedor']!=''){
		$grid->SelectCommand .= " AND u.id = '".mysql_real_escape_string($_GET['vendedor'])."' ";
	}


// Set output format to json 
$grid->dataType = 'json'; 
// Let the grid create the model 
$grid->setColModel(); 
// Set the url from where we obtain the data 
$grid->setUrl('grillas/GrillaPedidosAlmacen.php?vendedor='.$_GET['vendedor'].'&admin='.$_GET['admin']);  
//			
$grid->setColProperty("id_acc", 		array("hidden"=>true)); 
$grid->setColProperty("cliente", 		array("label"=>"Cliente","width"=>25,"resizable"=>false,"editable"=>false,'align'=>'center',"formatter"=>"js:fnUcWords"));
$grid->setColProperty("date_entered", 	array("label"=>"Fecha","width"=>25,"resizable"=>false,"editable"=>false,'align'=>'center'));
$grid->setColProperty("pedido", 		array("label"=>"No. Pedido","recordpos"=>"right", "width"=>20,"resizable"=>true,"editable"=>false));
$grid->setColProperty("account_id", 	array("hidden"=>true)); 
$grid->setColProperty("vendedor", 	    array("label"=>"Vendedor","width"=>50,"resizable"=>false,"editable"=>false,"align"=>"center","formatter"=>"js:fnUcWords"));
$grid->setColProperty("estado", 	    array("label"=>"Estado","width"=>20,"resizable"=>false,"editable"=>false));
$grid->setColProperty("estado_id", 		array("hidden"=>true)); 
$grid->setColProperty("anular", 	    array("label"=>" ","width"=>10,"resizable"=>false,"editable"=>false,"formatter"=>"js:fnAnular",'align'=>'center','search'=>false));
$grid->setColProperty("ver", 	        array("label"=>" ",  "width"=>15,"resizable"=>false,"editable"=>false,'align'=>'center',"formatter"=>"js:fnVer",'search'=>false));

//$grid->setColProperty("remision", 	    array("hidden"=>true,"label"=>"Facturar",  "width"=>30,"resizable"=>false,"editable"=>false,'align'=>'center',"formatter"=>"js:fnRemision",'search'=>false,"hidden"=>($_REQUEST['admin']?true:false)));

$grid->setColProperty("id", 	        array("hidden"=>true)); 
// Set some grid options 
$grid->setGridOptions(array("rowNum"		=>50,
							"rowList"		=>array(10,20,30,50,100),
							"sortname"		=>"date_entered",
							"sortorder"		=>"desc",	
							"direction"		=>"ltr", 						
							"caption"		=>"Pedidos Almacen",
							"rownumbers"	=>true,
							"width"			=>"900",
							"height"		=>"300",
							"hoverrows"		=>true));
// Enable navigator
// We can put JS from php
$custom = <<<CUSTOM
	function fnVer(cellValue, options, rowdata) {	
		var cellHtml = '<a href="javascript:void(0)" onclick="callfancy(\'detallePedidos.php?record='+rowdata.id+'&estado='+rowdata.estado_id+'&nopedido='+rowdata.pedido+'\',\'verpedido\');">Ver/Editar</a>';
		return cellHtml;
	}
	function fnAnular(cellValue, options, rowdata) {
		cellHtml = '&nbsp;';
                
		if(rowdata.estado_id == '1' || rowdata.estado_id == '5'){
			cellHtml = '<a href="javascript:void(0)" onclick="fnAnular(\''+rowdata.id+'\');" style="color:red;">Anular</a>';
		}
		return cellHtml;
	}
	function fnRemision(cellValue, options, rowdata) {
		var cellHtml = '&nbsp;';
		if(rowdata.estado_id == '1' || rowdata.estado_id == '5'){
			return cellHtml = '<a href="javascript:void(0)" onclick="callfancy(\'Remision.php?record='+rowdata.id+'&consecpedido='+rowdata.pedido+'\',\'remision\');" alt="Remisionar" title="Remisionar"><img src="themes/Sugar/images/remision.png" width="32" height="32"/></a>';
		}
		if(rowdata.estado_id == '2'){
			return cellHtml = '<label style="font-family:verdana; color:blue; font-size:x-small">En remision</label>';	
		}
		return cellHtml;
	}
	function fnUcWords(cellValue, options, rowdata) {
		return (cellValue + '').replace(/^([a-z])|\s+([a-z])/g, function ($1) {
			return $1.toUpperCase();
		});
	}
CUSTOM;
//en la siguiente funcion activo que cuando se seleccione la fila haga lo que necesito
// Enjoy 
$grid->toolbarfilter = true; 
$grid->setFilterOptions(array("stringResult"=>true)); 
$grid->setJSCode($custom);
$grid->navigator = true;
// Enable csv export
$grid->setNavOptions('navigator', array("pdf"=>true,"excel"=>true, "add"=>false,"edit"=>false,"del"=>false,"view"=>false));
// Enjoy 
$grid->renderGrid('#grid','#pager',true, null, null, true,true); 
$conn = null; 
?> 